const multer = require("multer");

const fileStorage = multer.diskStorage({
  destination: (req, file, cb) => {
    let uploadFolder;

    if (file.fieldname === "productPhoto") {
      uploadFolder = "public/products-upload";
    } else if (file.fieldname === "productVariationPhoto") {
      uploadFolder = "public/product-variation";
    } else if (file.fieldname === "productSubVariationPhoto") {
      uploadFolder = "public/product-sub-variation";
    } else if (file.fieldname === "productmenuPhoto") {
      uploadFolder = "public/productmenu-upload";
    } else if (file.fieldname === "uploadproductmenuPhoto") {
      uploadFolder = "public/productmenu-upload";
    } else if (file.fieldname === "rpafPhoto") {
      uploadFolder = "public/rpaf-upload";
    } else if (file.fieldname === "applicant_signaturePhoto") {
      uploadFolder = "public/rpaf-upload";
    } else if (file.fieldname === "rpafpaymentheadPhoto") {
      uploadFolder = "public/rpaf-payment-upload";
    } else if (file.fieldname === "rpafadminpaymentPhoto") {
      uploadFolder = "public/rpaf-admin-payment";
    } else if (file.fieldname === "note") {
      uploadFolder = "public/orderform/note";
    } else if (file.fieldname === "po_attachment") {
      uploadFolder = "public/orderform/note";
    } else if (file.fieldname === "uploadedImage") {
      uploadFolder = "public/orderform/delivered_picture";
    } else if (file.fieldname === "delivered_picture") {
      uploadFolder = "public/orderform/delivered_picture";
    } else if (file.fieldname === "rpafpaymentPhoto") {
      uploadFolder = "public/rpaf-payment";
    } else if (file.fieldname === "logisticpaymentPhoto") {
      uploadFolder = "public/logistic-payment";
    } else if (file.fieldname === "storeFile") {
      uploadFolder = "public/rpaf-build-credit-application-upload";
    } else if (file.fieldname === "birFile") {
      uploadFolder = "public/rpaf-build-credit-application-upload";
    } else if (file.fieldname === "businessPermitFile") {
      uploadFolder = "public/rpaf-build-credit-application-upload";
    } else if (file.fieldname === "dtiSecRegistrationFile") {
      uploadFolder = "public/rpaf-build-credit-application-upload";
    } else if (file.fieldname === "bankStatementPassbookFile") {
      uploadFolder = "public/rpaf-build-credit-application-upload";
    } else if (file.fieldname === "bankAuthorizationFile") {
      uploadFolder = "public/rpaf-build-credit-application-upload";
    } else if (file.fieldname === "otherFile") {
      uploadFolder = "public/rpaf-build-credit-application-upload";
    } else if (file.fieldname === "creditApprovalFile") {
      uploadFolder = "public/rpaf-build-credit-application-upload";
    } else if (file.fieldname === "govIdFile") {
      uploadFolder = "public/rpaf-build-credit-application-upload";
    } else if (file.fieldname === "tinFile") {
      uploadFolder = "public/rpaf-build-credit-application-upload";
    } else if (file.fieldname === "proof_of_payment") {
      uploadFolder = "public/proof_of_payment";
    } else if (file.fieldname === "file_2303") {
      uploadFolder = "public/file-2303";
    } else if (file.fieldname === "applicantSignature") {
      uploadFolder = "public/rpaf-build-credit-application-upload";
    }
    // PRODUCT IMAGES
    else if (file.fieldname === "product_images") {
      uploadFolder = "public/products";
    } else if (file.fieldname === "product_images_variation") {
      uploadFolder = "public/products";
    } else if (file.fieldname === "product_images_sub_variation") {
      uploadFolder = "public/products";
    } else if (file.fieldname === "product_image_update") {
      uploadFolder = "public/products";
    }
    // PRODUCT IMAGES
    else if (file.fieldname === "_storeFile") {
      uploadFolder = "../public_html/uploads/rpafuploads";
    } else if (file.fieldname === "_birFile") {
      uploadFolder = "../public_html/uploads/rpafuploads";
    } else if (file.fieldname === "_mayorFile") {
      uploadFolder = "../public_html/uploads/rpafuploads";
    } else if (file.fieldname === "_dtiFile") {
      uploadFolder = "../public_html/uploads/rpafuploads";
    } else if (file.fieldname === "_otherFile") {
      uploadFolder = "../public_html/uploads/rpafuploads";
    } else if (file.fieldname === "_bankFile") {
      uploadFolder = "../public_html/uploads/rpafuploads";
    } else if (file.fieldname === "_bankAuthorizationFile") {
      uploadFolder = "../public_html/uploads/rpafuploads";
    } else if (file.fieldname === "_approvalFile") {
      uploadFolder = "../public_html/uploads/rpafuploads";
    } else if (file.fieldname === "_governmentIDFile") {
      uploadFolder = "../public_html/uploads/rpafuploads";
    } else if (file.fieldname === "_tinIDFile") {
      uploadFolder = "../public_html/uploads/rpafuploads";
    } else if (file.fieldname === "release_order_image") {
      uploadFolder = "public/release-order-images";
    } else if (file.fieldname === "sellerLogo" || file.fieldname === "childCompany_sellerLogo") {
      uploadFolder = "public/sellerCompany-upload";
    }

    // SELLER LOGO OR BANNER
    else if (file.fieldname === "seller_logo" || file.fieldname === "seller_banner") {
      uploadFolder = "public/seller";
    } 
    
    // CLIENT VERIFICATIONS
    else if (file.fieldname === "client_facial_verification" || file.fieldname === "client_signature") {
      uploadFolder = "public/client-verifications";
    } 
    else {
      cb(new Error("Invalid fieldname"), false);
      return;
    }

    cb(null, uploadFolder);
  },
  filename: (req, file, cb) => {
    const date = new Date();
    const formattedDate = date.toISOString().replace(/:/g, "-") + "-";
    cb(null, formattedDate + file.originalname);
  },
});

const fileFilter = (req, file, cb) => {
  if (
    file.mimetype === "image/png" ||
    file.mimetype === "image/jpg" ||
    file.mimetype === "image/jpeg" ||
    file.mimetype === "application/vnd.openxmlformats-officedocument.wordprocessingml.document" || // DOCX
    file.mimetype === "application/pdf"
  ) {
    cb(null, true);
  } else {
    cb(new Error("File format not supported"), false);
  }
};

const multerConfig = (req, res, next) => {
  multer({
    storage: fileStorage,
    fileFilter: fileFilter,
    limits: {
      fileSize: 5 * 1024 * 1024, // 5MB
    },
  }).fields([
    {
      name: "productPhoto",
      maxCount: 1,
    },
    {
      name: "productVariationPhoto",
      maxCount: 1,
    },
    {
      name: "productSubVariationPhoto",
      maxCount: 1,
    },
    {
      name: "sellerLogo",
      maxCount: 1,
    },
    {
      name: "productmenuPhoto",
      maxCount: 1,
    },
    {
      name: "uploadproductmenuPhoto",
      maxCount: 1,
    },
    {
      name: "note",
      maxCount: 1,
    },
    {
      name: "uploadedImage",
      maxCount: 1,
    },
    {
      name: "delivered_picture",
      maxCount: 1,
    },
    {
      name: "rpafPhoto",
      maxCount: 1,
    },
    {
      name: "applicant_signaturePhoto",
      maxCount: 1,
    },
    {
      name: "rpafpaymentheadPhoto",
      maxCount: 1,
    },
    {
      name: "rpafadminpaymentPhoto",
      maxCount: 1,
    },
    {
      name: "rpafpaymentPhoto",
      maxCount: 1,
    },
    {
      name: "logisticpaymentPhoto",
      maxCount: 1,
    },
    {
      name: "childCompany_sellerLogo",
      maxCount: 1,
    },
    {
      name: "storeFile",
      maxCount: 1,
    },
    {
      name: "birFile",
      maxCount: 1,
    },
    {
      name: "businessPermitFile",
      maxCount: 1,
    },
    {
      name: "dtiSecRegistrationFile",
      maxCount: 1,
    },
    {
      name: "bankStatementPassbookFile",
      maxCount: 1,
    },
    {
      name: "bankAuthorizationFile",
      maxCount: 1,
    },
    {
      name: "otherFile",
      maxCount: 1,
    },
    {
      name: "creditApprovalFile",
      maxCount: 1,
    },
    {
      name: "govIdFile",
      maxCount: 1,
    },
    {
      name: "tinFile",
      maxCount: 1,
    },
    {
      name: "applicantSignature",
      maxCount: 1,
    },
    {
      name: "proof_of_payment",
      maxCount: 1,
    },
    {
      name: "po_attachment",
      maxCount: 1,
    },
    {
      name: "_storeFile",
      maxCount: 1,
    },
    {
      name: "_birFile",
      maxCount: 1,
    },
    {
      name: "_mayorFile",
      maxCount: 1,
    },
    {
      name: "_dtiFile",
      maxCount: 1,
    },
    {
      name: "_otherfile",
      maxCount: 1,
    },
    {
      name: "_bankFile",
      maxCount: 1,
    },
    {
      name: "_bankAuthorizationFile",
      maxCount: 1,
    },
    {
      name: "_approvalFile",
      maxCount: 1,
    },
    {
      name: "_governmentIDFile",
      maxCount: 1,
    },
    {
      name: "_tinIDFile",
      maxCount: 1,
    },
    {
      name: "release_order_image",
      maxCount: 1,
    },
    {
      name: "product_images",
      maxCount: 5,
    },
    {
      name: "product_images_variation",
      maxCount: 15,
    },
    {
      name: "product_images_sub_variation",
      maxCount: 15,
    },
    {
      name: "product_image_update",
      maxCount: 1,
    },
    {
      name: "file_2303",
      maxCount: 1,
    },
    {
      name: "seller_logo",
      maxCount: 1,
    },
    {
      name: "seller_banner",
      maxCount: 1,
    },
    {
      name: "client_facial_verification",
      maxCount: 1,
    },
    {
      name: "client_signature",
      maxCount: 1,
    },
  ])(req, res, next);
};

module.exports = multerConfig;
