const formatDate = (dateString) => {
    if (!dateString) {
        throw new Error("Date string is undefined or null");
    }

    const parts = dateString.split('-');
    if (parts.length !== 3) {
        throw new Error("Invalid date string format. Expected format: YYYY-MM-DD");
    }

    const [year, month, day] = parts.map(part => parseInt(part, 10));
    if (isNaN(year) || isNaN(month) || isNaN(day)) {
        throw new Error("Invalid date string format. Year, month, or day is not a valid number.");
    }

    return `${year}-${month.toString().padStart(2, '0')}-${day.toString().padStart(2, '0')}`;
};

module.exports = { formatDate };
