const express = require("express");
const { body, param } = require("express-validator");
const isAuth = require("../../middlewares/authorization");

const { checkout, mockCheckout, generateQr } = require("../../controllers/v3/checkout.controller");
const jsonParser = require("../../helpers/jsonParser");

const router = express.Router();

router.post("/", isAuth, jsonParser, checkout);
router.post("/mock", isAuth, mockCheckout);
router.get("/generate-qr", generateQr);

module.exports = router;
