const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
  getSelfCart,
  createUserCart,
  addUserCart,
  updateUserCart,
  removeUserCartByIds,
} = require("../../../controllers/v1.1/user-cart");

const router = express.Router();

router.get("/", isAuth, getSelfCart);
router.post("/", isAuth, addUserCart);
router.patch("/:user_cart_id", isAuth, updateUserCart);
router.post("/add-to-cart", isAuth, createUserCart);
router.post("/remove-cart-by-ids", isAuth, removeUserCartByIds);

module.exports = router;
