const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const radiusSetter = require("../../../middlewares/radius-sellers-setter");
const pagination = require("../../../middlewares/pagination");

const {
  findAllSellersCompany,
  getAllProductsBySellerCompany,
  getMicrositeHandleByName,
} = require("../../../controllers/v1.1/sellers-company");

const router = express.Router();

router.use(pagination);
router.get("/", radiusSetter, findAllSellersCompany);
router.get("/:sellerId/", getAllProductsBySellerCompany);
router.get("/microsite/handle", getMicrositeHandleByName);

module.exports = router;
