const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");
const pagination = require("../../../middlewares/pagination");
const radiusSetter = require("../../../middlewares/radius-sellers-setter");

const {
  findProductsByCategory,
  searchProducts,
  sortProductsByCategory,
  sortAllProducts,
} = require("../../../controllers/v1.1/products");

const ProductsMenu = require("../../../models/ProductMenu");

const router = express.Router();

router.use(pagination);
router.get(
  "/:categoryId/shop-by-category",
  [
    param("categoryId")
      .notEmpty()
      .custom((value, { req }) => {
        return ProductsMenu.findOne({
          where: {
            id: value,
          },
        }).then((isExist) => {
          if (!isExist) {
            return Promise.reject("Category Id does not exists");
          }
        });
      }),
  ],
  validation,
  radiusSetter,
  findProductsByCategory
);

router.get("/search", radiusSetter, searchProducts);
router.get("/:categoryId/sort", sortProductsByCategory);
router.get("/sort", sortAllProducts);

module.exports = router;
