const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");
const jsonParser = require("../../../helpers/jsonParser");

const { selfDetail, updateSelf } = require("../../../controllers/v1.1/me");

const router = express.Router();

router.get("/", isAuth, selfDetail);
router.patch("/", isAuth, jsonParser, updateSelf);
module.exports = router;
