const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
  getCustomFields,
  createCustomFields,
  createInternalForm,
} = require("../../../controllers/v1.1/internal-form");

const router = express.Router();

router.get("/", getCustomFields);
router.post("/", createInternalForm);
router.post("/custom-fields", createCustomFields);
module.exports = router;
