const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const jsonParser = require("../../../helpers/jsonParser");
const isAuth = require("../../../middlewares/authorization");

const {
  buildreditPayment,
  getBuildCreditOrders,
  externalBuildCreditApplication,
  externalBuildCreditApplication2,
  externalBuildCreditApplication3,
  findExternalBuildCreditApplicationBySourceId,
} = require("../../../controllers/v1.1/build-credit");

const router = express.Router();

router.get("/orders", isAuth, getBuildCreditOrders);
router.post("/payment", isAuth, jsonParser, buildreditPayment);

// External BuildCredit
router.post("/", externalBuildCreditApplication);
router.put("/", jsonParser, externalBuildCreditApplication2);
router.patch("/", jsonParser, externalBuildCreditApplication3);
router.get("/:source_id", findExternalBuildCreditApplicationBySourceId);

module.exports = router;
