const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
  getConversation,
  getChatsCustomerAndAdmin,
  sendMessageToAdmin,
} = require("../../../controllers/v1.1/chat-admin");

const router = express.Router();

router.get("/conversation/:adminId", isAuth, getConversation);
router.get(
  "/conversation/chats/:conversationId",
  isAuth,
  getChatsCustomerAndAdmin
);
router.post("/conversation/chat", isAuth, sendMessageToAdmin);

module.exports = router;
