const express = require("express");
const { body } = require("express-validator");

const {
  accountRegisterV2,
  accountDisable,
  accountRegisterFacebook,
  accountLoginFacebook,
  accountRegisterGoogle,
  accountLoginGoogle
} = require("../../../controllers/v1.1/accounts");

const isAuth = require("../../../middlewares/authorization");

const validateInput = require("../../../middlewares/validation");

const router = express.Router();

router.post(
  "/register",
  [
    body("firstName").notEmpty(),
    body("lastName").notEmpty(),
    body("email").notEmpty().isEmail(),
    body("password").notEmpty(),
  ],
  validateInput,
  accountRegisterV2
);
router.post("/disable", isAuth, accountDisable);

router.post("/facebook-register", accountRegisterFacebook);
router.post("/facebook-login", accountLoginFacebook);
router.post("/google-register", accountRegisterGoogle);
router.post("/google-login", accountLoginGoogle);

module.exports = router;
