const express = require("express");
const voucher = require("../../../controllers/voucher");
const voucherModel = require("../../../models/Vouchers");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const {
  createVoucher,
  getAllVoucher,
  getVoucherId,
  deleteVoucherId,
  updateVoucher,
} = require("../../../controllers/voucher");

const validateInput = require("../../../middlewares/validation");
const jsonParser = require("../../../helpers/jsonParser");
const router = express.Router();

// Routes
router.post(
  "/create",
  isAuth,
  [
    body("voucher_code").notEmpty(),
    body("amount").optional(),
    body("amount_in_percent").optional(),
    body("agent").notEmpty(),
    body("status").notEmpty(),
    body("valid_until").notEmpty(),
    body("in_percent").optional(),
    body("seller_voucher").optional(),
  ],
  createVoucher
);

router.put(
  "/:VoucherId/update",
  isAuth,
  [
    body("voucher_code").notEmpty(),
    body("amount").optional(),
    body("amount_in_percent").optional(),
    body("agent").notEmpty(),
    body("status").notEmpty(),
    body("valid_until").notEmpty(),
    body("in_percent").optional(),
    body("seller_voucher").optional(),
  ],
  updateVoucher
);

router.get("/all", isAuth, voucher.getAllVoucher);
router.get("/:VoucherId/search", isAuth, voucher.getVoucherId);
router.get("/:voucherCode/search-code", isAuth, voucher.getVoucherByVoucherCode);
router.delete("/:VoucherId/delete", isAuth, voucher.deleteVoucherId);
module.exports = router;
