const express = require("express");
const userCart = require("../../../controllers/user-cart");
const UserCartModel = require("../../../models/UserCart");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const {
    createUserCart,
    getAllUserCart,
    getUserCartId,
    deleteUserCart,
    updateUserCart,
    updateArea,
    
  } = require("../../../controllers/user-cart");

const validateInput = require("../../../middlewares/validation");
const jsonParser = require("../../../helpers/jsonParser");
const router = express.Router();

// Routes 
router.post("/create", 
    isAuth,
    // [
    //     body("user_id").notEmpty(),
    //     body("menu_id").notEmpty(),
    //     body("quantity").notEmpty(),
    //     body("created_at").notEmpty(),
    //     body("price").notEmpty(),
    //     body("total_price").notEmpty()
        
    // ],
    jsonParser,
    createUserCart);

    router.put("/:UserCartId/update", 
    isAuth, 
    [
        body("quantity").notEmpty(),
        
    ],
    updateUserCart);

    router.get("/all",isAuth, getAllUserCart);
    router.get("/:UserCartId/search",isAuth, getUserCartId);
    router.delete("/:UserCartId/delete",isAuth, deleteUserCart);


module.exports = router;