const express = require("express");
const trucks = require("../../../controllers/trucks");
const trucksModel = require("../../../models/Trucks");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const {
    createTruck,
    updateTruck
  } = require("../../../controllers/trucks");

const validateInput = require("../../../middlewares/validation");
const jsonParser = require("../../../helpers/jsonParser");
const router = express.Router();

// Routes 
router.post("/create", 
    isAuth,
    [
        body("logistics_id").notEmpty(),
        body("group_id").optional(),
        body("current_lat").notEmpty(),
        body("current_long").notEmpty(),
        body("driver_id").optional(),
        body("truck_plate_no").optional(),
        body("truck_type").optional()
        
    ],
    createTruck);

    router.put("/:TruckId/update", 
    isAuth, 
    
    [
        body("logistics_id").notEmpty(),
        body("group_id").optional(),
        body("current_lat").notEmpty(),
        body("current_long").notEmpty(),
        body("driver_id").optional(),
        body("truck_plate_no").optional(),
        body("truck_type").optional()
    ],
    updateTruck);

router.get("/all",isAuth, trucks.getAllTruck);
router.get("/:TruckId/search",isAuth, trucks.getTruckId);
router.delete("/:TruckId/delete",isAuth, trucks.deleteTruckId);

module.exports = router;