const express = require("express");
const truckTypeModel = require("../../../models/TruckType");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const {
    trucktype,
    createTruckType,
    getAllTruckType,
    getTruckTypeId,
    deleteTruckTypeId,
    updateTruckType
  } = require("../../../controllers/truck-type");

const validateInput = require("../../../middlewares/validation");
const jsonParser = require("../../../helpers/jsonParser");
const TruckType = require("../../../models/TruckType");
const router = express.Router();

// Routes 
router.post("/create", 
    isAuth,
    
    [
        body("logistics_id").notEmpty(),
        body("truck_type").notEmpty()
        
    ],
    createTruckType);

    router.put("/:TruckTypeId/update", 
    isAuth, 
    
    [
        body("logistics_id").notEmpty(),
        body("truck_type").notEmpty()
    ],
    updateTruckType);   

router.get("/all",isAuth, getAllTruckType);
router.get("/:TruckTypeId/search",isAuth, getTruckTypeId);
router.delete("/:TruckTypeId/delete",isAuth, deleteTruckTypeId);

module.exports = router;