const express = require("express");
const { query } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");

const {
    findAllOrders
  } = require("../../../controllers/track-orders");

const router = express.Router();

router.get("/all", 
  [
    query("orderId").notEmpty(),
    query("billingEmail").notEmpty()
  ],
  validation,
  findAllOrders
);

module.exports = router;