
const express = require("express");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");
const pagination = require("../../../middlewares/pagination");

const {
    createSellers,
    getAllSellers,
    getSellerId,
    updateSellerById,
    deleteSellerById,
    getProductsByCategoryAndSeller
  } = require("../../../controllers/sellers");

const jsonParser = require("../../../helpers/jsonParser");

 const router = express.Router();
 // Product Routes
 router.post("/create", 
 isAuth,
 jsonParser,
 [
     body("seller_id").notEmpty(),
     body("name").optional(),
     body("username").notEmpty(),
     body("password").notEmpty(),
     body("role").optional(),
     body("seller_logo").optional(),
     body("lat").optional(),
     body("address").optional(),
     body('isAuthorizedWarehouse').custom((value) => {
      if (value !== "Yes" && value !== "No") {
          throw new Error('isAuthorizedWarehouse must be "Yes" or "No"');
      }
      return true;
  }).optional(),
 ],
 createSellers);

router.put("/:id/update", 
 isAuth, 
 jsonParser,
 [
  body("seller_id").notEmpty(),
  body("name").optional(),
  body("username").notEmpty(),
  body("password").notEmpty(),
  body("role").optional(),
  body("seller_logo").optional(),
  body("lat").optional(),
  body("address").optional(),
  body('isAuthorizedWarehouse').custom((value) => {
    if (value !== "Yes" && value !== "No") {
        throw new Error('isAuthorizedWarehouse must be "Yes" or "No"');
    }
    return true;
}).optional(),
 ],
 updateSellerById);

router.use(pagination);
router.get("/all",getAllSellers);
router.get("/:sellerID/search",getSellerId);
router.get("/products/category/",getProductsByCategoryAndSeller);
router.delete("/:sellerID/delete",isAuth,deleteSellerById);

module.exports = router;
