const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");
const pagination = require("../../../middlewares/pagination");

const {
  createSellersCompany,
  createSellersChildCompany,
  updateSellersCompany,
  deleteSellersCompany,
  findSellersCompanyById,
  findAllSellersCompany,
  findProductsBySellersCompany,
} = require("../../../controllers/sellers-company");

const jsonParser = require("../../../helpers/jsonParser");

const router = express.Router();

router.post(
  "/create",
  isAuth,
  jsonParser,
  [
    body("data.parentCompany.companyName").notEmpty(),
    body("data.parentCompany.description").optional(),
    body("data.parentCompany.address").notEmpty(),
    body("data.parentCompany.latitude").optional(),
    body("data.parentCompany.longitude").optional(),
    body("data.parentCompany.owner").notEmpty(),
    body("data.parentCompany.sellerLogo").optional(),
    body("data.parentCompany.computationMethod").optional(),
    body("data.parentCompany.emailAddress").optional().isEmail(),
    body("data.parentCompany.contact_number").optional(),
    body("data.parentCompany.isParentCompany").optional(),
    body("data.parentCompany.parentCompany").optional(),
    body("data.parentCompany.smallItemFeePerKM").notEmpty(),
    body("data.parentCompany.smallItemFeeFixed").notEmpty(),
    body("data.parentCompany.bigItemFeePerKM").notEmpty(),
    body("data.parentCompany.bigItemFeeFixed").notEmpty(),
    body("data.parentCompany.flagdownBigKM").optional(),
    body("data.parentCompany.flagdownSmallKM").optional(),

    body("data.childCompany.childCompany_companyName").notEmpty(),
    body("data.childCompany.childCompany_description").optional(),
    body("data.childCompany.childCompany_address").notEmpty(),
    body("data.childCompany.childCompany_latitude").optional(),
    body("data.childCompany.childCompany_longitude").optional(),
    body("data.childCompany.childCompany_owner").notEmpty(),
    body("data.childCompany.childCompany_sellerLogo").optional(),
    body("data.childCompany.childCompany_computationMethod").optional(),
    body("data.childCompany.childCompany_emailAddress").optional().isEmail(),
    body("data.childCompany.childCompany_contact_number").optional(),
    body("data.childCompany.childCompany_smallItemFeePerKM").notEmpty(),
    body("data.childCompany.childCompany_smallItemFeeFixed").notEmpty(),
    body("data.childCompany.childCompany_bigItemFeePerKM").notEmpty(),
    body("data.childCompany.childCompany_bigItemFeeFixed").notEmpty(),
    body("data.childCompany.childCompany_flagdownBigKM").optional(),
    body("data.childCompany.childCompany_flagdownSmallKM").optional(),
  ],
  validation,
  createSellersCompany
);

router.post(
  "/:parentCompanyId/createChild",
  isAuth,
  jsonParser,
  [
    body("data.companyName").notEmpty(),
    body("data.description").optional(),
    body("data.address").notEmpty(),
    body("data.latitude").optional(),
    body("data.longitude").optional(),
    body("data.owner").notEmpty(),
    body("data.sellerLogo").optional(),
    body("data.computationMethod").optional(),
    body("data.emailAddress").optional().isEmail(),
    body("data.contact_number").optional(),
    body("data.smallItemFeePerKM").notEmpty(),
    body("data.smallItemFeeFixed").notEmpty(),
    body("data.bigItemFeePerKM").notEmpty(),
    body("data.bigItemFeeFixed").notEmpty(),
    body("data.flagdownBigKM").optional(),
    body("data.flagdownSmallKM").optional(),
  ],
  validation,
  createSellersChildCompany
);

router.put(
  "/:sellersCompanyId/update",
  isAuth,
  jsonParser,
  [
    body("data.companyName").optional(),
    body("data.description").optional(),
    body("data.address").optional(),
    body("data.latitude").optional(),
    body("data.longitude").optional(),
    body("data.owner").optional(),
    body("data.sellerLogo").optional(),
    body("data.computationMethod").optional(),
    body("data.emailAddress").optional().isEmail(),
    body("data.contact_number").optional(),
    body("data.smallItemFeePerKM").optional(),
    body("data.smallItemFeeFixed").optional(),
    body("data.bigItemFeePerKM").optional(),
    body("data.bigItemFeeFixed").optional(),
    body("data.flagdownBigKM").optional(),
    body("data.flagdownSmallKM").optional(),
  ],
  validation,
  updateSellersCompany
);

router.delete("/:sellersCompanyId/delete", isAuth, deleteSellersCompany);
router.get("/:sellersCompanyId/search", findSellersCompanyById);

router.use(pagination);
router.get("/all", findAllSellersCompany);
router.get("/:sellersCompanyId/company-all", findProductsBySellersCompany);

module.exports = router;
