const express = require("express");
const { body } = require("express-validator");
const validation = require("../../../../middlewares/routeValidation");
const isAuth = require("../../../../middlewares/authorization");
const jsonParser = require("../../../../helpers/jsonParser");
const pagination = require("../../../../middlewares/pagination");

const { getSellerVouchers, createSellerVoucher, softDeleteVoucher } = require("../../../../controllers/seller/voucher");

const router = express.Router();

router.use(pagination);
router.get("/", isAuth, pagination, getSellerVouchers);
router.post("/", isAuth, createSellerVoucher);
router.delete("/:voucher_id", isAuth, softDeleteVoucher);
// router.get("/:product_id", isAuth, getSellerProductById);
// router.post("/", isAuth, jsonParser, createSellerProduct);
// router.patch("/:product_id/:photo_id", isAuth, updateProductPhoto);
// router.put("/:product_id", isAuth, updateSellerProduct);

module.exports = router;
