const express = require("express");
const { body } = require("express-validator");
const validation = require("../../../../middlewares/routeValidation");
const isAuth = require("../../../../middlewares/authorization");
const jsonParser = require("../../../../helpers/jsonParser");
const pagination = require("../../../../middlewares/pagination");

const {
  getTopics,
  getTopicDetailByGuid,
  getArticleDetailById,
  getTopicVideosByTopicGuid,
  getVideoDetailByID,

  //DEMO ONLY
  createUnivTopics,
} = require("../../../../controllers/seller/seller-university");

const router = express.Router();

router.use(pagination);
router.get("/", pagination, getTopics);
router.get("/topic/:guid", getTopicDetailByGuid);
router.get("/article/:articleId", getArticleDetailById);
router.get("/videos/:guid", getTopicVideosByTopicGuid);
router.get("/videos/detail/:videoId", isAuth, getVideoDetailByID);

router.post("/demo/topic", createUnivTopics);

module.exports = router;
