const express = require("express");
const { body } = require("express-validator");
const validation = require("../../../../middlewares/routeValidation");
const isAuth = require("../../../../middlewares/authorization");
const jsonParser = require("../../../../helpers/jsonParser");
const pagination = require("../../../../middlewares/pagination");

const {
  getAllSellerProducts,
  getSellerProductById,
  createSellerProduct,
  updateProductPhoto,
  updateSellerProduct,
  deleteSellerProduct,
} = require("../../../../controllers/seller/products");

const router = express.Router();

router.use(pagination);
router.get("/", isAuth, getAllSellerProducts);
router.get("/:product_id", isAuth, getSellerProductById);
router.post("/", isAuth, jsonParser, createSellerProduct);
router.patch("/:product_id/:photo_id", isAuth, updateProductPhoto);
router.put("/:product_id", isAuth, updateSellerProduct);
router.delete("/:product_id", isAuth, deleteSellerProduct);

module.exports = router;
