const express = require("express");
const { body } = require("express-validator");
const validation = require("../../../../middlewares/routeValidation");
const isAuth = require("../../../../middlewares/authorization");
const jsonParser = require("../../../../helpers/jsonParser");
const pagination = require("../../../../middlewares/pagination");

const {
  getAllOrderForm,
  getOrderFormByIdWithOrderDetails,
  updateOrderForm,
  dashboardOrderData,
} = require("../../../../controllers/seller/order-form");

const router = express.Router();

router.use(pagination);
router.get("/", isAuth, getAllOrderForm);
router.get("/:reference_no", isAuth, getOrderFormByIdWithOrderDetails);
router.patch("/:reference_no", isAuth, jsonParser, updateOrderForm);
router.get("/dashboard/data", isAuth, dashboardOrderData);

module.exports = router;
