const express = require("express");
const isAuth = require("../../../../middlewares/authorization");

const {
  getConversations,
  getChatsByConversationId,
  sendMessageByConversationId,
} = require("../../../../controllers/seller/chat");

const router = express.Router();

router.get("/conversations", isAuth, getConversations);
router.get("/chats", isAuth, getChatsByConversationId);
router.post("/chats", isAuth, sendMessageByConversationId);

module.exports = router;
