const express = require("express");
const { body } = require("express-validator");
const validation = require("../../../../middlewares/routeValidation");
const isAuth = require("../../../../middlewares/authorization");
const jsonParser = require("../../../../helpers/jsonParser");

const {
  accountLogin,
  sellerCompanySignup,
  updateSellerCompanyBasicDetails,
  updateSellerOrBannerImage,
  updateSellerShippingSettings,
  myselfDetails,
} = require("../../../../controllers/seller/accounts");

const router = express.Router();

router.post("/login", [body("username").notEmpty(), body("password").notEmpty()], validation, accountLogin);
router.post(
  "/company/register",
  [
    body("company_name").notEmpty(),
    body("company_description").notEmpty(),
    body("address").notEmpty(),
    body("latitude").notEmpty().isFloat(),
    body("longitude").notEmpty().isFloat(),
    body("owner").notEmpty().isString(),
    body("email_address").notEmpty().isEmail(),
    body("phone_number_primary").notEmpty().isLength({ min: 11, max: 12 }),
    body("phone_number_optional_1").optional().isLength({ min: 11, max: 12 }),
    body("phone_number_optional_2").optional().isLength({ min: 11, max: 12 }),
    body("initial_username").notEmpty(),
    body("initial_password").notEmpty(),
  ],
  validation,
  sellerCompanySignup
);
router.patch("/company", isAuth, updateSellerCompanyBasicDetails);
router.patch("/company/logo", isAuth, updateSellerOrBannerImage);
router.patch("/company/shipping", isAuth, updateSellerShippingSettings);
router.get("/me", isAuth, myselfDetails);
module.exports = router;
