const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
    addSellerRating
} = require("../../../controllers/seller-rating");

const router = express.Router();

router.post("/:sellerId/rate", 
    isAuth, 
    [
        param("sellerId").notEmpty().isInt(),
        body("rate").notEmpty().isInt().custom(value => {
            const rate = parseInt(value);
            if (rate < 0 || rate > 5) {
                throw new Error('Rate must be between 0 and 5.');
            }
            return true;
        }),
        body("review").optional(),
    ],
    validation,
    addSellerRating
);

module.exports = router;
