const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
    createRpafPaymentHead,
    getAllRpafPaymentHead,
    getrpafPHId,
    deleterpafPH,
    updaterpafPH,
} = require("../../../controllers/rpaf-payment-head");

const jsonParser = require("../../../helpers/jsonParser");

const router = express.Router();

router.post("/create",isAuth, jsonParser,createRpafPaymentHead);
router.get("/all",isAuth,getAllRpafPaymentHead);
router.get("/:rpafPHID/search",isAuth, getrpafPHId);
router.delete("/:rpafPHID/delete", isAuth,deleterpafPH);
router.put("/:rpafPHID/update",isAuth, jsonParser,updaterpafPH);


module.exports = router;