const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
    getAllRpafPayment,
    getrpafPId,
    getRpafPaymentByCustomerId,
    deleterpafP,
    createRpafPayment,
    updaterpafP,
    createRpafMultiplePayments
} = require("../../../controllers/rpaf-payment");

const jsonParser = require("../../../helpers/jsonParser");

const router = express.Router();

router.get("/all",isAuth, getAllRpafPayment);
router.get("/:rpafPID/search",isAuth, getrpafPId);
router.get("/:customerId/search-by-customer", isAuth, getRpafPaymentByCustomerId);
router.delete("/:rpafPID/delete",isAuth, deleterpafP);
router.post("/create",isAuth,jsonParser, createRpafPayment);
router.post("/create-rpaf-multiple-payments", isAuth, jsonParser, createRpafMultiplePayments);
router.put("/:rpafPID/update",isAuth,jsonParser, updaterpafP);



module.exports = router;