const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
    getAllRpafAdminPayment,
    getrpafAPId,
    deleterpafAP,
    createRpafAP,
    updateRpafAP,
} = require("../../../controllers/rpaf-admin-payment");

const jsonParser = require("../../../helpers/jsonParser");

const router = express.Router();

router.get("/all",isAuth, getAllRpafAdminPayment);
router.get("/:rpafAPID/search",isAuth, getrpafAPId);
router.delete("/:rpafAPID/delete",isAuth, deleterpafAP);
router.post("/create",isAuth,jsonParser, createRpafAP);
router.put("/:rpafAPID/update",isAuth,jsonParser, updateRpafAP);


module.exports = router;