const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const { buildcreditMailer } = require("../../../controllers/v1.1/buildcredit-mailer");
const { getAllRpaf, getrpafId, deleterpaf, createRpaf, updateRpaf } = require("../../../controllers/rpaf");

const jsonParser = require("../../../helpers/jsonParser");

const router = express.Router();

router.get("/all", isAuth, getAllRpaf);
router.get("/:rpafID/search", isAuth, getrpafId);
router.delete("/:rpafID/delete", isAuth, deleterpaf);
router.post("/create", isAuth, jsonParser, createRpaf);
router.put("/:rpafID/update", isAuth, jsonParser, updateRpaf);

router.post("/mailer", isAuth, buildcreditMailer);

module.exports = router;
