const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");
const jsonParser = require("../../../helpers/jsonParser");

const {
  createBuildCreditApplicationFirst,
  BuildCreditApplicationSecond,
  BuildCreditApplicationThird,
  updateBuildCreditApplication,
  deleteBuildCreditApplication,
  findBuildCreditApplication,
  findAllBuildCreditApplication,
  sendOtp,
  verifyOtp,
} = require("../../../controllers/rpaf-build-credit-application");

const router = express.Router();

router.post("/:customerId/application", isAuth, createBuildCreditApplicationFirst);

router.put("/:customerId/application-2", isAuth, jsonParser, BuildCreditApplicationSecond);

router.put("/:customerId/application-3", isAuth, jsonParser, BuildCreditApplicationThird);

router.put("/:customerId/update", isAuth, updateBuildCreditApplication);

router.delete("/:creditAppId/delete", isAuth, deleteBuildCreditApplication);

router.get("/:customerId/list", isAuth, findBuildCreditApplication);

router.get("/all", isAuth, findAllBuildCreditApplication);

router.post(
  "/send-otp",
  isAuth,
  [
    body("mobileNumber")
      .isLength({ min: 12, max: 12 })
      .withMessage("Mobile number must be 12 digits")
      .custom((value) => {
        const mobileNumber = String(value);
        if (!mobileNumber.startsWith("639")) {
          throw new Error("Mobile number must start with 639");
        }
        return true;
      }),
  ],
  validation,
  sendOtp
);

router.post("/verify-otp", isAuth, verifyOtp);
module.exports = router;
