const express = require("express");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const {
  recommendedItems,
  submitCustomerQuotation,
  getQuotationDetail,
  acceptOrDenyQuotation,
  acceptOrDenyQuotationDetail,
} = require("../../../controllers/quotation.controller");

const router = express.Router();

router.post("/recommended-items", isAuth, recommendedItems);
router.post("/submit-quotation", isAuth, submitCustomerQuotation);
router.get("/", isAuth, getQuotationDetail);
router.patch("/quotation", isAuth, acceptOrDenyQuotation);
router.patch("/quotation-detail", isAuth, acceptOrDenyQuotationDetail);

module.exports = router;
