const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");
const radiusSetter = require("../../../middlewares/radius-sellers-setter");
const pagination = require("../../../middlewares/pagination");

const {
  createProducts,
  createVariation,
  createSubVariation,
  updateProduct,
  updateVariation,
  updateSubVariation,
  deleteProducts,
  findProductsById,
  // findProductsPerSeller,
  findProductsByAvailability,
  findProductsByCategory,
  findAllProducts,
  nearestSellersToCustomer,
  findAllProductsWithSeller,
} = require("../../../controllers/products");

const jsonParser = require("../../../helpers/jsonParser");

const router = express.Router();

router.post(
  "/create",
  isAuth,
  jsonParser,
  // // [
  // //     body("data.productId").notEmpty(),
  // //     body("data.productName").notEmpty(),
  // //     body("data.productType").notEmpty(),
  // //     body("data.description").optional(),
  // //     body("data.price").notEmpty(),
  // //     body("data.discountedPrice").notEmpty(),
  // //     body("data.productPhoto").optional(),
  // //     body("data.quantityLimit").optional(),
  // //     body("data.stocks").notEmpty(),
  // //     body("data.available").notEmpty(),
  // // ],
  // validation,
  createProducts
);

router.post("/:productId/createvariation", isAuth, jsonParser, createVariation);
router.post(
  "/:variationId/createSubVariation",
  isAuth,
  jsonParser,
  createSubVariation
);

router.put("/:productId/products", jsonParser, updateProduct);
router.put("/:variationId/variations", jsonParser, updateVariation);
router.put("/:subVariationId/subvariations", jsonParser, updateSubVariation);

// router.put("/:productId/update",
//     isAuth,
//     jsonParser,
//     // [
//     //     body("data.productId").notEmpty(),
//     //     body("data.productName").notEmpty(),
//     //     body("data.productType").notEmpty(),
//     //     body("data.description").optional(),
//     //     body("data.price").notEmpty(),
//     //     body("data.discountedPrice").notEmpty(),
//     //     body("data.productPhoto").optional(),
//     //     body("data.quantityLimit").optional(),
//     //     body("data.stocks").notEmpty(),
//     //     body("data.available").notEmpty(),
//     // ],
//     validation,
//     updateProducts
// );

router.delete("/:productId/delete", isAuth, deleteProducts);

router.get("/:productId/search", findProductsById);

router.use(pagination);
// router.get("/:sellerId/perSeller", findProductsPerSeller);
router.get("/available", findProductsByAvailability);
router.get(
  "/:categoryId/shop-by-category",
  radiusSetter,
  findProductsByCategory
);
router.get("/all", radiusSetter, findAllProducts);
router.get("/nearest-sellers", isAuth, nearestSellersToCustomer);
// router.get('/findAllProductsWithSeller', findAllProductsWithSeller);
module.exports = router;
