const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
    addProductRating,
    getAllProductRating,
    getProductRatingId
} = require("../../../controllers/product-rating");


const router = express.Router();

router.post("/:referenceNo/rate", 
    isAuth, 
    [
        body("productId").notEmpty().isInt(),
        body("productRate").notEmpty().isInt()
        .custom(value => {
        const rate = parseInt(value);
            if (rate < 0 || rate > 5) {
                throw new Error('Product rate must be between 0 and 5.');
            }
            return true;
        }),
        body("productReview").optional(),
    ],
    validation,
    addProductRating
);

router.get("/all", isAuth, getAllProductRating);
router.get("/:productId/search", isAuth, getProductRatingId);

module.exports = router;