const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
    getOrderFormDetails,
    getOrderFormDetailsById,
    deleteOrderFormDetailsById,
    createOrderFormDetails,
    updateOrderFormDetails
} = require("../../../controllers/order-form-details");

const jsonParser = require("../../../helpers/jsonParser");

const router = express.Router();

router.get("/all",isAuth, getOrderFormDetails);
router.get("/:OrderFormDetailsID/search",isAuth, getOrderFormDetailsById);
router.delete("/:OrderFormDetailsID/delete",isAuth, deleteOrderFormDetailsById);
router.post("/create",isAuth, jsonParser, createOrderFormDetails);
router.put("/:OrderFormDetailsID/update",isAuth, jsonParser, updateOrderFormDetails);


module.exports = router;