const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
    getAllOrderform,
    getrorderformId,
    deleteorderform,
    createorderform,
    updateorderform,
    getAllOrdersByAgent
} = require("../../../controllers/order-form");

const jsonParser = require("../../../helpers/jsonParser");

const router = express.Router();

router.get("/all", isAuth, getAllOrderform);
router.get("/agent-orders", isAuth, getAllOrdersByAgent);
router.get("/:orderformID/search", isAuth, getrorderformId);
router.delete("/:orderformID/delete", isAuth, deleteorderform);
router.post("/create",isAuth, jsonParser, createorderform);
router.put("/:orderformID/update",isAuth, jsonParser, updateorderform);

module.exports = router;