const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
    findAllOrders,
    findOrderByReferenceNo
} = require("../../../controllers/order-list");



const router = express.Router();

router.get("/list-of-orders", isAuth, findAllOrders);
router.get("/:referenceNo/view-order-history", isAuth, findOrderByReferenceNo);

module.exports = router;