const express = require("express");
const logistics = require("../../../controllers/logistics");
const LogisticsModel = require("../../../models/Logistics");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const {
    createLogistics,
    getAllLogistics,
    getLogisticsId,
    deleteLogistics,
    updateLogistic
  } = require("../../../controllers/logistics");

const validateInput = require("../../../middlewares/validation");
const jsonParser = require("../../../helpers/jsonParser");
const router = express.Router();

// Routes 
router.post("/create", 
    isAuth,
    [
        body("company_name").notEmpty(),
        body("address").notEmpty(),
        body("owner").notEmpty(),
        body("initial_username").optional(),
        body("intiial_password").optional(),
        
    ],
    createLogistics);


    router.put("/:LogisticId/update", 
    isAuth, 
    [
        body("company_name").notEmpty(),
        body("address").notEmpty(),
        body("owner").notEmpty(),
        body("initial_username").optional(),
        body("intiial_password").optional(),
    ],
    updateLogistic);

    router.get("/all",isAuth, getAllLogistics);
    router.get("/:LogisticId/search",isAuth, getLogisticsId);
    router.delete("/:LogisticId/delete",isAuth, deleteLogistics);

module.exports = router;