const express = require("express");
const logisticsUser = require("../../../controllers/logistics-user");
const LogisticsUserModel = require("../../../models/LogisticsUser");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const {
    createLogisticsUser,
    getAllLogisticsUser,
    getLogisticsUserId,
    deleteLogisticsUser,
    updateLogisticUser
  } = require("../../../controllers/logistics-user");

const validateInput = require("../../../middlewares/validation");
const jsonParser = require("../../../helpers/jsonParser");
const router = express.Router();

// Routes 
router.post("/create", 
    isAuth,
    [
        body("logistics_id").notEmpty(),
        body("Username").optional(),
        body("password").optional(),
        body("Fullname").optional(),
        body("email_address").optional(),
        body("roles").optional(),

        
    ],
    createLogisticsUser);

    router.put("/:LogisticUserId/update", 
    isAuth, 
    [
        body("logistics_id").notEmpty(),
        body("Username").optional(),
        body("password").optional(),
        body("Fullname").optional(),
        body("email_address").optional(),
        body("roles").optional(),

    ],
    updateLogisticUser);

    router.get("/all",isAuth, getAllLogisticsUser);
    router.get("/:LogisticUserId/search",isAuth, getLogisticsUserId);
    router.delete("/:LogisticUserId/delete",isAuth, deleteLogisticsUser);

    module.exports = router;