const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
    createLogisticPayment,
    createLogisticMultiplePayments,
    getLogisticPaymentById,
    getAllLogisticPayment,
    getLogisticPaymentByCustomerId, 
    updateLogisticPayment,
    deleteLogisticPayment,

} = require("../../../controllers/logistic-payment");

const jsonParser = require("../../../helpers/jsonParser");

const router = express.Router();

router.post("/create", isAuth, jsonParser, createLogisticPayment);
router.post("/create-logistic-multiple-payments", isAuth, jsonParser, createLogisticMultiplePayments);
router.get("/:customerId/search-by-customer", isAuth, getLogisticPaymentByCustomerId);
router.get("/:logisticPaymentId/search-by-id", isAuth, getLogisticPaymentById);
router.get("/show-all", isAuth, getAllLogisticPayment);
router.put("/:logisticPaymentId/update", isAuth, jsonParser, updateLogisticPayment);
router.delete("/:logisticPaymentId/delete", isAuth, deleteLogisticPayment);
module.exports = router;