const express = require("express");
const location = require("../../../controllers/location");
const LocationModel = require("../../../models/Location");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const {
    createLocation,
    getAllLocation,
    getLocationId,
    deleteLocation,
    updateLocation
  } = require("../../../controllers/location");

const validateInput = require("../../../middlewares/validation");
const jsonParser = require("../../../helpers/jsonParser");
const router = express.Router();

// Routes 
router.post("/create", 
    isAuth,
    [
        body("vehicle_id").notEmpty(),
        body("order_id").optional(),
        body("date").notEmpty(),
        body("time").notEmpty(),
        body("latitude").notEmpty(),
        body("longtitude").notEmpty()
        
    ],
    createLocation);


    router.put("/:LocationId/update", 
    isAuth, 
    [
        body("vehicle_id").notEmpty(),
        body("order_id").optional(),
        body("date").notEmpty(),
        body("time").notEmpty(),
        body("latitude").notEmpty(),
        body("longtitude").notEmpty()
    ],
    updateLocation);


router.get("/all",isAuth, getAllLocation);
router.get("/:LocationId/search",isAuth, getLocationId);
router.delete("/:LocationId/delete",isAuth, deleteLocation);

    module.exports = router;