const express = require("express");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");
const validation = require("../../../middlewares/routeValidation");

const {
    createHardwareCredit,
    updateHardwareCredit,
    deleteHardwareCredit,
    findAllHardwareCredit,
    findHardwareCreditById
} = require("../../../controllers/hardware-credit");
const Seller = require("../../../models/Seller");

const router = express.Router();

router.post('/create',
    isAuth,
    [
        body("sellerId").notEmpty().isUUID()
        .custom((value, { req }) => {
            return Seller.findByPk(value)
            .then((seller) => {
                if(!seller) {
                    return Promise.reject("Seller ID does not exists!");
                }
            })
            .catch((error) => {
                return Promise.reject(error);
            })
        }),
        body("amount").notEmpty(),
        body("status").notEmpty().isBoolean()
    ],
    validation,
    createHardwareCredit
);

router.put('/:referenceNo/update',
    isAuth,
    [
        body("sellerId").notEmpty().isUUID()
        .custom((value, { req }) => {
            return Seller.findByPk(value)
            .then((seller) => {
                if(!seller) {
                    return Promise.reject("Seller ID does not exists!");
                }
            })
            .catch((error) => {
                return Promise.reject(error);
            })
        }),
        body("amount").notEmpty(),
        body("status").notEmpty().isBoolean()
    ],
    validation,
    updateHardwareCredit
);

router.delete('/:referenceNo/delete', isAuth, deleteHardwareCredit);
router.get('/:referenceNo/search', isAuth, findHardwareCreditById);
router.get('/show-all', isAuth, findAllHardwareCredit);

module.exports = router;