const express = require("express");
const featureProducts = require("../../../controllers/feature-products");
const featureProductsModel = require("../../../models/FeatureProducts");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const {
    getFeaturedProducts,
    getBestSellerProducts,
    getDiscountedProducts,
    getNewProducts,
    getBestSellerProductsByMenuId,
    
    
  } = require("../../../controllers/feature-products");

const validateInput = require("../../../middlewares/validation");
const jsonParser = require("../../../helpers/jsonParser");
const router = express.Router();



router.get("/all",isAuth, getFeaturedProducts);
router.get("/best",isAuth, getBestSellerProducts);
router.get("/best-seller-id/:menu_id",isAuth, getBestSellerProductsByMenuId);
router.get("/discounted",isAuth, getDiscountedProducts);
router.get("/new-products",isAuth, getNewProducts);

    


module.exports = router;