const express = require("express");
const driver = require("../../../controllers/driver");
const driverModel = require("../../../models/Drivers");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const {
    createDriver,
    updateDriverId
  } = require("../../../controllers/driver");

const validateInput = require("../../../middlewares/validation");
const jsonParser = require("../../../helpers/jsonParser");
const router = express.Router();

// Routes 

router.post("/create", 
    isAuth,
    [
        body("logistics_id").notEmpty(),
        body("name").notEmpty(),
        body("address").notEmpty(),
        body("username").notEmpty(),
        body("password").notEmpty(),
        
    ],
    createDriver);

    router.put("/:DriverId/update", 
    isAuth, 
    [
        body("logistics_id").notEmpty(),
        body("name").notEmpty(),
        body("address").notEmpty(),
        body("username").notEmpty(),
        body("password").notEmpty(),
    ],
    updateDriverId);


router.get("/all",isAuth, driver.getDriver);
router.get("/:DriverId/search",isAuth, driver.getDriverId);
router.delete("/:DriverId/delete",isAuth, driver.deleteDriverId);


module.exports = router;