const express = require("express");
const { body } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
    createCustomer,
    updateCustomer,
    deleteCustomer,
    findCustomerById,
    findAllCustomer
} = require("../../../controllers/customer");

const jsonParser = require("../../../helpers/jsonParser");

const router = express.Router();

router.post("/create", isAuth, createCustomer);
router.put("/:customerId/update", isAuth, updateCustomer);
router.delete("/:customerId/delete", isAuth, deleteCustomer);
router.get("/:customerId", isAuth, findCustomerById);
router.get("/", isAuth, findAllCustomer);

module.exports = router;