const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
    createCreditLimit,
    updateCreditLimitID,
    getAllCreditLimit,
    getCreditLimitById,
    deleteCreditlimitById,
} = require("../../../controllers/credit-limit");

const jsonParser = require("../../../helpers/jsonParser");

const router = express.Router();

router.get("/all", getAllCreditLimit);
router.get("/:CreditlimitID/search", getCreditLimitById);
router.delete("/:CreditlimitID/delete", deleteCreditlimitById);
router.post("/create",jsonParser, createCreditLimit);
router.put("/:CreditlimitID/update", jsonParser, updateCreditLimitID);


module.exports = router;