const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
  checkout,
  distanceCustomerToSeller,
  getShippingFee,
  getPaymentMethods,
  customerOrderAgain
} = require("../../../controllers/checkout");

const router = express.Router();
const jsonParser = require("../../../helpers/jsonParser");

// Route to handle checkout process
router.post("/checkout", isAuth, jsonParser, checkout); // Remove :customer_id from the route
router.post("/calculate-distance", isAuth, distanceCustomerToSeller);
router.get("/shipping-fee", isAuth, getShippingFee);
router.get("/payment-methods", isAuth, getPaymentMethods);
router.post("/reorder", isAuth, customerOrderAgain)
module.exports = router;
