const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");

const {
  customerToSellerChat,
  sellerToCustomerChat,
  deleteChat,
  getConversationCustomerAndSeller,
  getChatsCustomerAndSeller,
  getConversationBySellerId,
} = require("../../../controllers/chats");

const router = express.Router();
const jsonParser = require("../../../helpers/jsonParser");

// Route to handle checkout process
router.post("/chat-seller", isAuth, customerToSellerChat);
// Route for seller to customer chat
router.post("/chat-customer/:sellerId", isAuth, sellerToCustomerChat);
router.delete("/delete-chat/:chatId", isAuth, deleteChat);

router.get("/sellers/conversations", isAuth, getConversationCustomerAndSeller);
router.get(
  "/sellers/chat-list/:conversationId",
  isAuth,
  getChatsCustomerAndSeller
);
router.get(
  "/sellers/conversation/:sellerId",
  isAuth,
  getConversationBySellerId
);

module.exports = router;
