const express = require("express");
const { body, param } = require("express-validator");
const validation = require("../../../middlewares/routeValidation");
const isAuth = require("../../../middlewares/authorization");


const {

    sendMessageForBuyer,
    sendMessageForSeller,
    deleteChat
} = require("../../../controllers/chat-logistics");

const router = express.Router();
const jsonParser = require("../../../helpers/jsonParser");


router.post('/sendMessageForBuyer/:seller_id',isAuth, sendMessageForBuyer);

router.post('/sendMessageForSeller/:buyer_id', isAuth, sendMessageForSeller);

router.delete('/chats/:chatId', isAuth, deleteChat);

module.exports = router;
