const express = require("express");
const location = require("../../../controllers/location");
const AreaModel = require("../../../models/Area");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const {
    createArea,
    getAllArea,
    getAreaId,
    deleteAreaId,
    updateLocation,
    updateArea,
    
  } = require("../../../controllers/area");

const validateInput = require("../../../middlewares/validation");
const jsonParser = require("../../../helpers/jsonParser");
const router = express.Router();

// Routes 
router.post("/create", 
    isAuth,
    [
        body("area").notEmpty(),
        
    ],
    createArea);


    router.put("/:AreaId/update", 
    isAuth, 
    [
        body("area").notEmpty(),
        
    ],
    updateArea);

router.get("/all",isAuth, getAllArea);
router.get("/:AreaId/search",isAuth, getAreaId);
router.delete("/:AreaId/delete",isAuth, deleteAreaId);

module.exports = router;