const express = require("express");
const announcements = require("../../../controllers/announcements");
const AnnouncementsModel = require("../../../models/Announcements");
const { body, param } = require("express-validator");
const isAuth = require("../../../middlewares/authorization");

const {
    createAnnouncements,
    getAllAnnouncements,
    getAnnouncementsId,
    deleteAnnouncements,
    updateAnnouncements
  } = require("../../../controllers/announcements");

const validateInput = require("../../../middlewares/validation");
const jsonParser = require("../../../helpers/jsonParser");
const router = express.Router();

// Routes 
router.post("/create", 
    isAuth,
    [
        body("title").notEmpty(),
        body("description").notEmpty(),
        body("for_user").notEmpty(),
        body("end_date").notEmpty().isDate(),
        
    ],
    createAnnouncements);


    router.put("/:AnnouncementsId/update", 
    isAuth, 
    [
        body("title").notEmpty(),
        body("description").notEmpty(),
        body("for_user").notEmpty(),
        body("end_date").notEmpty().isDate()
    ],
    updateAnnouncements);

  router.get("/all",isAuth, getAllAnnouncements);
  router.get("/:AnnouncementsId/search",isAuth, getAnnouncementsId);
  router.delete("/:AnnouncementsId/delete",isAuth, deleteAnnouncements);

    module.exports = router;